/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.evolvedmekanism.multiblock.apt;

import fr.iglee42.evolvedmekanism.config.EMConfig;
import fr.iglee42.evolvedmekanism.multiblock.apt.TileEntityAPTCasing;
import fr.iglee42.evolvedmekanism.registries.EMRecipeType;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.attribute.ChemicalAttributeValidator;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.math.FloatingLong;
import mekanism.api.recipes.ItemStackGasToItemStackRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.common.capabilities.chemical.multiblock.MultiblockChemicalTankBuilder;
import mekanism.common.capabilities.energy.BasicEnergyContainer;
import mekanism.common.config.value.CachedIntValue;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.sync.dynamic.ContainerSync;
import mekanism.common.inventory.slot.InputInventorySlot;
import mekanism.common.inventory.slot.OutputInventorySlot;
import mekanism.common.lib.Color;
import mekanism.common.lib.multiblock.IValveHandler;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class APTMultiblockData
extends MultiblockData
implements IValveHandler {
    @ContainerSync
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getInput", "getInputCapacity", "getInputNeeded", "getInputFilledPercentage"}, docPlaceholder="input tank")
    public IGasTank inputTank = (IGasTank)MultiblockChemicalTankBuilder.GAS.input((MultiblockData)this, () -> ((CachedIntValue)EMConfig.general.aptInputStorage).getOrDefault(), this::hasRecipeWith, ChemicalAttributeValidator.ALWAYS_ALLOW, this.createSaveAndComparator());
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getInputSlot"}, docPlaceholder="input slot")
    InputInventorySlot inputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getOutputSlot"}, docPlaceholder="output slot")
    OutputInventorySlot outputSlot;
    @ContainerSync
    public int progress;
    @ContainerSync
    public int defaultRecipeProgress = -1;
    public int lastProgress;
    @ContainerSync
    public IEnergyContainer energyContainer;
    public ItemStackGasToItemStackRecipe currentRecipe;
    public float prevGasScale;

    public APTMultiblockData(TileEntityAPTCasing tile) {
        super((BlockEntity)tile);
        this.gasTanks.add(this.inputTank);
        this.inputSlot = InputInventorySlot.at(item -> this.hasRecipeForInputs((ItemStack)item, (GasStack)this.inputTank.getStack()), this::hasRecipeWith, (IContentsListener)this.createSaveAndComparator(), (int)28, (int)40);
        this.inventorySlots.add(this.inputSlot);
        this.outputSlot = OutputInventorySlot.at((IContentsListener)this.createSaveAndComparator(), (int)132, (int)40);
        this.inventorySlots.add(this.outputSlot);
        this.energyContainer = BasicEnergyContainer.create((FloatingLong)((FloatingLong)EMConfig.general.aptEnergyStorage.getOrDefault()), automationType -> this.isFormed(), type -> this.isFormed(), (IContentsListener)this.createSaveAndComparator());
        this.energyContainers.add(this.energyContainer);
    }

    private boolean hasRecipeWith(ItemStack item) {
        return this.getWorld().m_7465_().m_44013_((RecipeType)EMRecipeType.APT.getRecipeType()).stream().anyMatch(r -> r.getItemInput().testType((Object)item));
    }

    private boolean hasRecipeWith(Gas gas) {
        return this.getWorld().m_7465_().m_44013_((RecipeType)EMRecipeType.APT.getRecipeType()).stream().anyMatch(r -> ((ChemicalStackIngredient.GasStackIngredient)r.getChemicalInput()).testType((Chemical)gas));
    }

    private boolean hasRecipeForInputs(ItemStack stack, GasStack gas) {
        return this.hasRecipeWith(stack) && this.getWorld().m_7465_().m_44013_((RecipeType)EMRecipeType.APT.getRecipeType()).stream().anyMatch(r -> ((ChemicalStackIngredient.GasStackIngredient)r.getChemicalInput()).testType((Object)gas));
    }

    public boolean tick(Level world) {
        float gasScale;
        boolean needsPacket = super.tick(world);
        if (world.f_46443_) {
            return false;
        }
        if (this.currentRecipe == null) {
            world.m_7465_().m_44013_((RecipeType)EMRecipeType.APT.getRecipeType()).stream().filter(r -> r.test(this.inputSlot.getStack(), (ChemicalStack)((GasStack)this.inputTank.getStack()))).findFirst().ifPresent(r -> {
                this.currentRecipe = r;
                this.markDirty();
                this.defaultRecipeProgress = this.progress = (int)((long)EMConfig.general.aptDefaultDuration.getOrDefault() * (((ChemicalStackIngredient.GasStackIngredient)r.getChemicalInput()).getNeededAmount((Object)((GasStack)this.inputTank.getStack())) / 100L));
            });
        } else {
            if (!this.currentRecipe.test(this.inputSlot.getStack(), (ChemicalStack)((GasStack)this.inputTank.getStack()))) {
                this.currentRecipe = null;
                this.progress = 0;
                this.defaultRecipeProgress = -1;
                this.markDirty();
                return true;
            }
            if (this.canProcess()) {
                this.extractEnergy(0, (FloatingLong)EMConfig.general.aptEnergyConsumption.getOrDefault(), null, Action.EXECUTE);
                --this.progress;
                if (this.progress == 0) {
                    this.extractItem(0, Math.toIntExact(this.currentRecipe.getItemInput().getNeededAmount((Object)this.inputSlot.getStack())), null, Action.EXECUTE);
                    this.inputTank.extract(((ChemicalStackIngredient.GasStackIngredient)this.currentRecipe.getChemicalInput()).getNeededAmount((Object)((GasStack)this.inputTank.getStack())), Action.EXECUTE, AutomationType.INTERNAL);
                    this.outputSlot.insertItem(this.currentRecipe.getOutput(this.inputSlot.getStack(), (ChemicalStack)((GasStack)this.inputTank.getStack())), Action.EXECUTE, AutomationType.INTERNAL);
                    this.currentRecipe = null;
                    this.defaultRecipeProgress = -1;
                }
                needsPacket = true;
            }
        }
        if (this.lastProgress != this.progress) {
            this.markDirty();
            needsPacket = true;
        }
        if ((gasScale = MekanismUtils.getScale((float)this.prevGasScale, (IChemicalTank)this.inputTank)) != this.prevGasScale) {
            needsPacket = true;
            this.prevGasScale = gasScale;
        }
        return needsPacket;
    }

    private boolean canProcess() {
        return this.getEnergy(0).greaterOrEqual((FloatingLong)EMConfig.general.aptEnergyConsumption.getOrDefault()) && (this.outputSlot.isEmpty() || this.outputSlot.insertItem(this.currentRecipe.getOutput(this.inputSlot.getStack(), (ChemicalStack)((GasStack)this.inputTank.getStack())), Action.SIMULATE, AutomationType.INTERNAL).m_41619_());
    }

    public void writeUpdateTag(CompoundTag tag) {
        super.writeUpdateTag(tag);
        tag.m_128405_("progress", this.progress);
        tag.m_128405_("defaultRecipeProgress", this.defaultRecipeProgress);
        tag.m_128350_("scale", this.prevGasScale);
        tag.m_128365_("gas", (Tag)((GasStack)this.inputTank.getStack()).write(new CompoundTag()));
    }

    public void readUpdateTag(CompoundTag tag) {
        super.readUpdateTag(tag);
        NBTUtils.setFloatIfPresent((CompoundTag)tag, (String)"scale", scale -> {
            this.prevGasScale = scale;
        });
        NBTUtils.setIntIfPresent((CompoundTag)tag, (String)"progress", pg -> {
            this.progress = pg;
        });
        NBTUtils.setIntIfPresent((CompoundTag)tag, (String)"defaultRecipeProgress", pg -> {
            this.defaultRecipeProgress = pg;
        });
        NBTUtils.setGasStackIfPresent((CompoundTag)tag, (String)"gas", value -> this.inputTank.setStack((ChemicalStack)value));
    }

    protected int getMultiblockRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents((long)this.inputTank.getStored(), (long)this.inputTank.getCapacity());
    }

    public boolean handlesSound(TileEntityAPTCasing tile) {
        return tile.m_58899_().equals((Object)this.getMinPos().m_7918_(3, 0, 0)) || tile.m_58899_().equals((Object)this.getMaxPos().m_7918_(-3, 0, 0));
    }

    public double getScaledProgress() {
        return this.defaultRecipeProgress == -1 ? 0.0 : (double)(this.defaultRecipeProgress - this.progress) / (double)this.defaultRecipeProgress;
    }

    public Color getColor() {
        return this.inputTank.isEmpty() ? Color.WHITE : Color.rgb((int)((GasStack)this.inputTank.getStack()).getChemicalTint());
    }
}

